#property copyright "InstaForex"
#property link      "http://www.instaforex.com/"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Red
#property indicator_width1 2
// ---- input parameters
extern int MomPeriod = 11;
extern int SmoothPeriod = 6;
extern double Level = 0;

// ---- buffers
double indBuffer[];

// +------------------------------------------------------------------+
// | Custom indicator initialization function                         |
// +------------------------------------------------------------------+
int init()
{
	string short_name;
	// ---- indicator line
	SetIndexStyle(0, DRAW_LINE);
	SetIndexBuffer(0, indBuffer);	
	short_name = "IFX AnchoredMom(" + MomPeriod + "," + SmoothPeriod + ")";
	IndicatorShortName(short_name);
	SetIndexLabel(0, short_name);
	// ----
	SetIndexDrawBegin(0, MomPeriod);
	// ----
	SetLevelValue(0, Level);
	SetLevelValue(1, -Level);
	// ----
	return (0);
}

// +------------------------------------------------------------------+
// | Momentum                                                         |
// +------------------------------------------------------------------+
int start()
{
	int SMAPeriod = 2 * MomPeriod + 1;
	
	if (Bars <= SMAPeriod)
		return (0);
		
	int i, counted_bars = IndicatorCounted();
	
	// ---
	if (counted_bars < 1)
		for (i = 1; i <= SMAPeriod; i++)
			indBuffer[Bars - i] = 0.0;
	// ---
	i = Bars - MathMax(SMAPeriod, counted_bars) - 1;
	// ---
	while (i >= 0)
	{
		i--;
		double SMA = iMA(NULL, Period(), SMAPeriod, 0, MODE_SMA, PRICE_CLOSE, i);
		double EMA = iMA(NULL, Period(), SmoothPeriod, 0, MODE_EMA, PRICE_CLOSE, i);
		// ---
		if (SMA == 0)
			continue;
		indBuffer[i] = 100 * (EMA / SMA - 1);
	}
	// ---
	return (0);
}
// +------------------------------------------------------------------+