#property copyright "InstaForex"
#property link      "http://www.instaforex.com/"

#property indicator_separate_window
#property indicator_buffers 4
#property indicator_color1 Red
#property indicator_color2 Blue
#property indicator_color3 Blue
#property indicator_color4 Red
#property indicator_style2 STYLE_DOT
#property indicator_width3 3
#property indicator_width4 3

extern int Fast_MA_Period = 12;
extern int Slow_MA_Period = 26;
extern int Signal_MA_Period = 9;

double MacdBufferBlue[];
double MacdBufferRed[];
double SignalBuffer[];
double LineBuffer[];

int init()
{
	SetIndexStyle(0, DRAW_LINE);
	SetIndexStyle(1, DRAW_LINE);
	SetIndexStyle(2, DRAW_HISTOGRAM);
	SetIndexStyle(3, DRAW_HISTOGRAM);
	SetIndexDrawBegin(0, Slow_MA_Period);
	SetIndexDrawBegin(1, Slow_MA_Period + Signal_MA_Period);
	SetIndexDrawBegin(2, Slow_MA_Period + Signal_MA_Period);
	SetIndexDrawBegin(3, Slow_MA_Period + Signal_MA_Period);
	IndicatorDigits(Digits + 1);

	SetIndexBuffer(0, LineBuffer);
	SetIndexBuffer(1, SignalBuffer);
	SetIndexBuffer(2, MacdBufferBlue);
	SetIndexBuffer(3, MacdBufferRed);

	IndicatorShortName("IFX FullMACD(" + Fast_MA_Period + "," + Slow_MA_Period + "," + Signal_MA_Period + ")");
	SetIndexLabel(0, "Line");
	SetIndexLabel(1, "Signal");
	SetIndexLabel(2, "MACD");
	SetIndexLabel(3, "MACD");
	return (0);
}

// +------------------------------------------------------------------+
// | Custom indicator iteration function                              |
// +------------------------------------------------------------------+
int start()
{
	int limit;
	double volFirst = 0;
	double volSecond = 0;

	int counted_bars = IndicatorCounted();
	if (counted_bars < 0)
		return (-1);
	if (counted_bars > 0)
		counted_bars--;
	limit = Bars - counted_bars;
	if (counted_bars == 0)
		limit -= 1 + 1;

	// =====  
	for (int i = 0; i < limit; i++)
		LineBuffer[i] = iMA(NULL, 0, Fast_MA_Period, 0, MODE_EMA, PRICE_CLOSE, i) - iMA(NULL, 0, Slow_MA_Period, 0, MODE_EMA, PRICE_CLOSE, i);

	for (i = 0; i < limit; i++)
	{
		MacdBufferBlue[i] = 0.0;
		MacdBufferRed[i] = 0.0;

		SignalBuffer[i] = iMAOnArray(LineBuffer, Bars, Signal_MA_Period, 0, MODE_SMA, i);
		volFirst = LineBuffer[i] - SignalBuffer[i];
		volSecond = LineBuffer[i + 1] - SignalBuffer[i];
		if (volFirst > volSecond)
			MacdBufferBlue[i] = volFirst;
		else
			MacdBufferRed[i] = volFirst;
	}

	return (0);
}
// +------------------------------------------------------------------+