#property copyright "Copyright 2014, InstaForex"
#property link      "http://www.instaforex.com"
#property version   "1.00"
#property strict
// ----
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 clrGreen
#property indicator_style1 STYLE_SOLID
#property indicator_width1 2
#property indicator_color2 clrRed
#property indicator_style2 STYLE_DOT
#property indicator_level1 50
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_DOT
// ----
input int SmoothFactor = 5;
// ----
int RSI_Period = 14;
int Wilders_Period;
int StartBar, LastAlertBar;
datetime LastAlertTime;
double TrLevelSlow[];
double AtrRsi[];
double MaAtrRsi[];
double Rsi[];
double RsiMa[];

// +------------------------------------------------------------------+
// |                                                                  |
// +------------------------------------------------------------------+
int init()
{
	Wilders_Period = RSI_Period * 2 - 1;
	if (Wilders_Period < SmoothFactor)
	{
		StartBar = SmoothFactor;
	}
	else
	{
		StartBar = Wilders_Period;
	}
	// ----
	IndicatorBuffers(6);
	SetIndexBuffer(0, RsiMa);
	SetIndexStyle(0, DRAW_LINE, STYLE_SOLID, 2);
	SetIndexLabel(0, "Value 1");
	SetIndexDrawBegin(0, StartBar);
	SetIndexStyle(1, DRAW_LINE, STYLE_DOT);
	SetIndexBuffer(1, TrLevelSlow);
	SetIndexLabel(1, "Value 2");
	SetIndexDrawBegin(1, StartBar);
	SetIndexBuffer(2, AtrRsi);
	SetIndexBuffer(3, MaAtrRsi);
	SetIndexBuffer(4, Rsi);
	IndicatorShortName(StringConcatenate("IFX QQE(", SmoothFactor, ")"));
	// ----
	LastAlertBar = Bars - 1;
	return (0);
}

// +------------------------------------------------------------------+
// |                                                                  |
// +------------------------------------------------------------------+
int start()
{
	int counted, i;
	double rsi0, rsi1, dar, tr, dv;
	// ----
	if (Bars <= StartBar)
		return (0);
	// ----
	counted = IndicatorCounted();
	if (counted < 1)
		for (i = Bars - StartBar; i < Bars; i++)
		{
			TrLevelSlow[i] = 0.0;
			AtrRsi[i] = 0.0;
			MaAtrRsi[i] = 0.0;
			Rsi[i] = 0.0;
			RsiMa[i] = 0.0;
		}
	counted = Bars - counted - 2;
	// ----
	for (i = counted; i >= 0; i--)
		Rsi[i] = iRSI(NULL, 0, RSI_Period, PRICE_CLOSE, i);
	for (i = counted; i >= 0; i--)
	{
		RsiMa[i] = iMAOnArray(Rsi, 0, SmoothFactor, 0, MODE_EMA, i);
		AtrRsi[i] = MathAbs(RsiMa[i + 1] - RsiMa[i]);
	}
	for (i = counted; i >= 0; i--)
		MaAtrRsi[i] = iMAOnArray(AtrRsi, 0, Wilders_Period, 0, MODE_EMA, i);
	// ----
	i = counted + 1;
	tr = TrLevelSlow[i];
	rsi1 = iMAOnArray(Rsi, 0, SmoothFactor, 0, MODE_EMA, i);
	while (i > 0)
	{
		i--;
		rsi0 = iMAOnArray(Rsi, 0, SmoothFactor, 0, MODE_EMA, i);
		dar = iMAOnArray(MaAtrRsi, 0, Wilders_Period, 0, MODE_EMA, i) * 4.236;
		dv = tr;
		if (rsi0 < tr)
		{
			tr = rsi0 + dar;
			if (rsi1 < dv)
				if (tr > dv)
					tr = dv;
		}
		else
			if (rsi0 > tr)
			{
				tr = rsi0 - dar;
				if (rsi1 > dv)
					if (tr < dv)
						tr = dv;
			}
		TrLevelSlow[i] = tr;
		rsi1 = rsi0;
	}

	// ----
	return (0);
}

// +------------------------------------------------------------------+
// |                                                                  |
// +------------------------------------------------------------------+
// +------------------------------------------------------------------+
// |                                                                  |
// +------------------------------------------------------------------+
string TF2Str(int period)
{
	switch (period)
	{
	case PERIOD_M1:
		return ("M1");
	case PERIOD_M5:
		return ("M5");
	case PERIOD_M15:
		return ("M15");
	case PERIOD_M30:
		return ("M30");
	case PERIOD_H1:
		return ("H1");
	case PERIOD_H4:
		return ("H4");
	case PERIOD_D1:
		return ("D1");
	case PERIOD_W1:
		return ("W1");
	case PERIOD_MN1:
		return ("MN");
	}
	return (IntegerToString(Period()));
}
// +------------------------------------------------------------------+